% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{desc_output}
\alias{desc_output}
\title{desc_output}
\usage{
desc_output(desctable, target = c("df", "pander", "DT"), digits = 2, ...)
}
\arguments{
\item{desctable}{The desctable to output}

\item{target}{The desired target. One of "df", "pander", or "DT".}

\item{digits}{The number of digits to display. The p values will be simplified under 1E-digits}

\item{...}{Other arguments to pass to \code{data.frame}, \code{pander::pander}, or \code{DT::datatable}}
}
\value{
The output object (or corresponding side effect)
}
\description{
Output a desctable to the desired target format
}
\details{
Output a simple or grouped desctable to a different formats.
Currently available formats are\itemize{
  \item data.frame ("df")
  \item pander ("pander")
  \item datatable ("DT")
}

All numerical values will be rounded to the digits argument.
If statistical tests are presents, p values below 1E-digits will be replaced with "< 1E-digits"
(eg. "< 0.01" for values below 0.01 when digits = 2)
}
\seealso{
\code{\link[DT]{datatable}}

\code{\link[pander]{pander}}

Other desc_table core functions: 
\code{\link{desc_table}()},
\code{\link{desc_tests}()}
}
\concept{desc_table core functions}
