% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependentsim.R
\name{draw_from_multivariate_corr}
\alias{draw_from_multivariate_corr}
\title{Draw random samples from the given random structure}
\usage{
draw_from_multivariate_corr(random_structure, n_samples, size_factors = NULL)
}
\arguments{
\item{random_structure}{The structure of the random data to draw, computed by get_random_structure()}

\item{n_samples}{The number of samples to generate}

\item{size_factors}{Vector of length n_samples of size factors for DESeq2-type data. By default, all samples are given 1. Not used if no datasets has type DESeq2.}
}
\value{
A list of generated datasets. List names correspond to those of the datasets used to generate the random structure. Each dataset has n_samples columns.
}
\description{
Draw random samples from the given random structure
}
\examples{
#' # Generate example data with Sigma as its covariance matrix
library(MASS)
Sigma = matrix(c(
  1,      0.8,    0,  0,  0,  0,
  0.8,    1,      0,  0,  0,  0,
  0,      0,      1,  0,  0,  0,
  0,      0,      0,  1,  0,  0,
  0,      0,      0,  0,  1,  0.3,
  0,      0,      0,  0,  0.3, 1
), nrow=6, ncol=6)
norm_data <- t(mvrnorm(n=20, mu=c(0,0,0,0,0,0), Sigma=Sigma))

# Simulate draws mimicking that data
rs_normal <- get_random_structure(list(data=norm_data), method="pca", rank=2, type="normal")
draws_normal <- draw_from_multivariate_corr(rs_normal, n_samples=30)
}
