% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ulsif.R
\name{ulsif}
\alias{ulsif}
\title{Unconstrained least-squares importance fitting}
\usage{
ulsif(
  df_numerator,
  df_denominator,
  intercept = TRUE,
  scale = "numerator",
  nsigma = 10,
  sigma_quantile = NULL,
  sigma = NULL,
  nlambda = 20,
  lambda = NULL,
  ncenters = 200,
  centers = NULL,
  parallel = FALSE,
  nthreads = NULL,
  progressbar = TRUE
)
}
\arguments{
\item{df_numerator}{\code{data.frame} with exclusively numeric variables with
the numerator samples}

\item{df_denominator}{\code{data.frame} with exclusively numeric variables
with the denominator samples (must have the same variables as
\code{df_denominator})}

\item{intercept}{\code{logical} Indicating whether to include an intercept
term in the model. Defaults to \code{TRUE}.}

\item{scale}{\code{"numerator"}, \code{"denominator"}, or \code{NULL},
indicating whether to standardize each numeric variable according to the
numerator means and standard deviations, the denominator means and standard
deviations, or apply no standardization at all.}

\item{nsigma}{Integer indicating the number of sigma values (bandwidth
parameter of the Gaussian kernel gram matrix) to use in cross-validation.}

\item{sigma_quantile}{\code{NULL} or numeric vector with probabilities to
calculate the quantiles of the distance matrix to obtain sigma values. If
\code{NULL}, \code{nsigma} values between \code{0.05} and \code{0.95} are
used.}

\item{sigma}{\code{NULL} or a scalar value to determine the bandwidth of the
Gaussian kernel gram matrix. If \code{NULL}, \code{nsigma} values between
\code{0.05} and \code{0.95} are used.}

\item{nlambda}{Integer indicating the number of \code{lambda} values
(regularization parameter), by default, \code{lambda} is set to
\code{10^seq(3, -3, length.out = nlambda)}.}

\item{lambda}{\code{NULL} or numeric vector indicating the lambda values to
use in cross-validation}

\item{ncenters}{Maximum number of Gaussian centers in the kernel gram
matrix. Defaults to all numerator samples.}

\item{centers}{\code{NULL} or numeric matrix with the same dimensions as the
data, indicating the centers for the Gaussian kernel gram matrix.}

\item{parallel}{logical indicating whether to use parallel processing in the
cross-validation scheme.}

\item{nthreads}{\code{NULL} or integer indicating the number of threads to
use for parallel processing. If parallel processing is enabled, it defaults
to the number of available threads minus one.}

\item{progressbar}{Logical indicating whether or not to display a progressbar.}
}
\value{
\code{ulsif}-object, containing all information to calculate the
density ratio using optimal sigma and optimal weights.
}
\description{
Unconstrained least-squares importance fitting
}
\examples{
set.seed(123)
# Fit model
dr <- ulsif(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
ulsif(numerator_small, denominator_small, sigma = 2, lambda = 2)
}
\references{
Kanamori, T., Hido, S., & Sugiyama, M. (2009). A least-squares
approach to direct importance estimation. Journal of Machine Learning
Research, 10, 1391-1445. Available from
\url{https://jmlr.org/papers/v10/kanamori09a.html}
}
