% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{decrease}
\alias{decrease}
\title{The decrease coefficient}
\usage{
decrease(middle, breast)
}
\arguments{
\item{middle}{numeric, the diameter or circumference at middle height.}

\item{breast}{numeric, the diameter or circumference at breast height.}
}
\value{
A vector of decrease coefficients.
}
\description{
This coefficient expresses the ratio between the diameter
(or circumference) at mid-height of the bole and the diameter
(or circumference) measured at breast height.
}
\details{
Both \code{middle} and \code{breast} arguments should be of the
same type (either diameter or circumference). Not mixture.
}
\examples{
decrease(30, 120)
decrease(middle = 40, breast = 90)
}
