% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{baseFunction}
\alias{baseFunction}
\title{Recursive function for creating nested data structures}
\usage{
baseFunction(currentData, remainingFactors, fun = identity, funArgs = list())
}
\arguments{
\item{currentData}{data frame containing the current subset of data to process.}

\item{remainingFactors}{character vector of factor names still to be processed.}

\item{fun}{function to apply to each final data subset. Default is \code{identity}.}

\item{funArgs}{list of additional arguments to pass to \code{fun}.}
}
\value{
A nested list structure where each level corresponds to a factor,
or the result of applying \code{fun} to the data subset if no factors remain.
}
\description{
Internal recursive function that creates nested list structures by
sequentially grouping data by factors and applying a function to each subset.
This is the core engine behind nestedFunBuilder and related functions.
}
\details{
This function works recursively:
\itemize{
  \item Base case: If no factors remain, applies \code{fun} to the current data
  \item Recursive case: Groups data by the first remaining factor, then calls
    itself on each subset with the remaining factors
}
}
\keyword{internal}
