% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr_access.R
\name{get_branches_heights}
\alias{get_branches_heights}
\title{Get height attributes from a dendrogram}
\usage{
get_branches_heights(
  dend,
  sort = TRUE,
  decreasing = FALSE,
  include_leaves = FALSE,
  ...
)
}
\arguments{
\item{dend}{a dendrogram.}

\item{sort}{logical. Should the heights be sorted?}

\item{decreasing}{logical. Should the sort be increasing or decreasing? Not available for partial sorting.}

\item{include_leaves}{logical (FALSE). Should the output include the leaves value (0's).}

\item{...}{not used.}
}
\value{
a vector of the dendrogram's nodes heights (excluding leaves).
}
\description{
Get height attributes of a dendrogram's branches
}
\examples{

hc <- hclust(dist(USArrests[1:4, ]), "ave")
dend <- as.dendrogram(hc)
get_branches_heights(dend)
}
