% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_sequences.R
\name{drop_sequences}
\alias{drop_sequences}
\title{Remove Sequences of a DNAbin list object}
\usage{
drop_sequences(dna, identifier, drop = TRUE)
}
\arguments{
\item{dna}{a \link[ape:DNAbin]{DNAbin} list object.}

\item{identifier}{a character vector containing sequence names.}

\item{drop}{Logical. If \code{TRUE}, sequence names in \code{identifier} will
be dropped from \code{dna}. If \code{FALSE}, sequence names absent in \code{identifier}
will be dropped instead.}
}
\value{
an object of class \link[ape:DNAbin]{DNAbin}.
}
\description{
\code{drop_sequences()} removes sequences of a FASTA file by its names.
}
\details{
\code{drop_sequences()} relies on exact match between sequence names within
a fasta file and \code{identifier} argument.
}
\examples{

# Create a vector of sequence names to drop or keep.
identifier <- names(geophagus)[1:3]

# Remove sequences listed in identifier
drop_sequences(geophagus, identifier, drop = TRUE)

# Remove sequences not listed in identifier
drop_sequences(geophagus, identifier, drop = FALSE)

}
\author{
Pedro S. Bittencourt
}
