% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclairs.R
\name{getCov}
\alias{getCov}
\alias{getCor}
\alias{getCov,eclairs-method}
\alias{getCor,eclairs-method}
\title{Get full covariance/correlation matrix from \link{eclairs}}
\usage{
getCov(ecl, lambda, ...)

getCor(ecl, lambda, ...)

\S4method{getCov}{eclairs}(ecl, lambda, ...)

\S4method{getCor}{eclairs}(ecl, lambda, ...)
}
\arguments{
\item{ecl}{eclairs decomposition}

\item{lambda}{shrinkage parameter for the convex combination.}

\item{...}{other arguments}
}
\value{
p x p covariance/correlation matrix
}
\description{
Get full covariance/correlation matrix from \link{eclairs} decomposition
}
\details{
The full matrix is computationally expensive to compute and uses a lot of memory for large p.  So it is better to use \link{decorrelate} or \link{mult_eclairs} to perform projections in \eqn{O(np)} time.
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)
rownames(Y) <- paste0("sample_", seq(n))
colnames(Y) <- paste0("gene_", seq(p))

# eclairs decomposition
ecl <- eclairs(Y)

# extract covariance implied by eclairs decomposition
getCov(ecl)[1:3, 1:3]

}
