# Create a small test distance matrix
test_data <- iris[1:10, 1:4]
dist_mat <- dist(test_data)
dist_mat_mat <- as.matrix(dist_mat)

group_factor <- iris$Species[1:10]

test_that("visualize_distances works with numeric matrix (Heatmap)", {
  p <- visualize_distances(
    dist_mat = dist_mat_mat,
    method = "heatmap",
    group = group_factor,
    main_title = "Test Heatmap",
    max_n = 10
  )
  expect_s3_class(p, "pheatmap")  # This is the class returned
})

test_that("errors for non-square or non-symmetric matrices", {
  bad_mat <- matrix(1:12, nrow = 3)
  expect_error(
    visualize_distances(bad_mat),
    "Matrix must be square"
  )

  asym_mat <- matrix(1:16, 4, 4)
  expect_error(
    visualize_distances(asym_mat),
    "Input matrix is not symmetric"
  )
})

test_that("k validation works", {
  expect_error(
    visualize_distances(dist_mat, method = "mds_classic", k = 0),
    "k must be an integer"
  )

  expect_error(
    visualize_distances(dist_mat, method = "mds_classic", k = 10),
    "k must be an integer"
  )
})

test_that("weights validation works", {
  bad_weights <- c(1,2,3)
  expect_error(
    visualize_distances(dist_mat, method = "mds_weighted", weights = bad_weights),
    "Length of weights must match"
  )

  neg_weights <- rep(-1, nrow(test_data))
  expect_error(
    visualize_distances(dist_mat, method = "mds_weighted", weights = neg_weights),
    "Weights must be non-negative"
  )
})
