% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mds.R
\name{plot_mds}
\alias{plot_mds}
\title{Plot MDS Results with Grouped Scatter and Density Plots (Internal)}
\arguments{
\item{dist_mat}{A distance matrix or object convertible to a distance matrix.}

\item{k}{Integer. Number of dimensions to retain in MDS (default is 3).}

\item{weights}{Optional numeric vector of weights for weighted MDS. If \code{NULL},
classical MDS is performed.}

\item{group}{Optional factor or vector indicating group membership for observations,
used for coloring plots.}

\item{main_title}{Optional character string for the main plot title.}
}
\value{
A \code{ggmatrix} object from \code{GGally} representing the
  pairs plot with scatterplots and density plots.
}
\description{
This internal function performs classical or weighted Multidimensional Scaling (MDS)
on a given distance matrix and visualizes the resulting coordinates using a
pairwise scatterplot matrix with density plots on the diagonal. Grouping information
can be provided for colored visual separation.
}
\details{
This is an internal helper function. It is not recommended to call \code{plot_mds()} directly.
Instead, use \code{\link{visualize_distances}()}, which wraps this function.

Weighted MDS is performed with \code{vegan::wcmdscale} if \code{weights} are provided;
otherwise, classical MDS (\code{cmdscale}) is used. Diagonal panels show density plots
by group, and off-diagonal panels show scatter plots by group.
}
\examples{
# Load example dataset
data("Data_HC_contamination", package = "dbrobust")
# Subset of 20 rows
Data_small <- Data_HC_contamination[1:20, ]

# Define variable types
cont_vars <- c("V1", "V2", "V3", "V4")
cat_vars  <- c("V5", "V6", "V7")
bin_vars  <- c("V8", "V9")

# Use column 'w_loop' as weights
w <- Data_small$w_loop

# Compute robust distances using GGower
dist_sq_ggower <- dbrobust::robust_distances(
  data = Data_small,
  cont_vars = cont_vars,
  bin_vars  = bin_vars,
  cat_vars  = cat_vars,
  w = w,
  alpha = 0.10,
  method = "ggower"
)

# Create factor indicating Normal vs Outlier
n_obs <- nrow(dist_sq_ggower)
group_vec <- rep("Normal", n_obs)
group_vec[attr(dist_sq_ggower, "outlier_idx")] <- "Outlier"
group_factor <- factor(group_vec, levels = c("Normal", "Outlier"))

# Plot MDS
dbrobust::plot_mds(
  dist_mat = dist_sq_ggower,
  k = 2,
  group = group_factor,
  main_title = "MDS of Data_HC_contamination (GGower) with Outliers"
)

}
\keyword{internal}
