% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.table.R
\name{as.data.frame}
\alias{as.data.frame}
\alias{as.data.frame.dbi.table}
\title{Coerce to a Data Frame}
\usage{
\method{as.data.frame}{dbi.table}(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  n = getOption("dbitable.max.fetch", 10000L)
)
}
\arguments{
\item{x}{a \code{\link{dbi.table}}.}

\item{row.names}{a logical value. This argument is not used.}

\item{optional}{a logical value. This argument is not used.}

\item{\dots}{additional arguments are ignored.}

\item{n}{an integer value. When nonnegative, the underlying SQL query includes a
'LIMIT \code{n}' clause and \code{n} is also passed to
\code{\link[DBI]{dbFetch}}. When negative, the underlying SQL query does
not include a LIMIT clause and all rows in the result set are returned.}
}
\value{
a \code{data.frame}.
}
\description{
Execute a \code{\link{dbi.table}}'s underlying SQL query and return the
  result set as a \code{\link[base]{data.frame}}. By default, the
  result set is limited to 10,000 rows. See Details.
}
\details{
By default, \code{as.data.frame} returns up to 10,000 rows (see the
  \code{n} argument). To override this limit, either call
  \code{as.data.frame} and provide the \code{n} argument (e.g., \code{n = -1}
  to return the entire result set), or set the option
  \code{dbitable.max.fetch} to the desired default value of \code{n}.
}
\examples{
  duck <- chinook.duckdb()
  Artist <- dbi.table(duck, DBI::Id("Artist"))

  as.data.frame(Artist, n = 7)[]

  \dontshow{DBI::dbDisconnect(duck)}

}
\seealso{
\code{\link[base]{as.data.frame}} (the generic method in the
  \pkg{base} package).
}
