% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewn.r
\name{skewn}
\alias{skewn}
\title{Computes the skewness of a numeric vector}
\usage{
skewn(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector representing a random variable.}

\item{na.rm}{Logical value to remove NA values. The default is set to TRUE.}
}
\value{
The value of the the skewness of given vector
}
\description{
The skewness is about the departure from symmetry of a frequency
distribution. Therefore,
It is about asymmetry. One way to assess asymmetry of a random
variable is to compute
an statistics representing its skewness. The current function
an dimensionless statistics
of the skewness of given vector.
}
\details{
The skewness of a random variable is the third moment
of the standardized variable.
There are several ways of parameterizing an skewness estimator,
such as depending on the
third moment and the standard deviation of the random variable.
}
\examples{
y.var<-rnorm(100);x.var<-rbeta(100,.2,2)
skewn(y.var)
skewn(x.var)

}
\author{
Christian Salas-Eljatib.
}
