% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp.r
\name{interp}
\alias{interp}
\title{Interpolation function}
\usage{
interp(
  x,
  y,
  xlu = NA,
  ylu = NA,
  arrange = y,
  asc = TRUE,
  completename.x = "xlu",
  completename.y = "ylu",
  overwrite = FALSE
)
}
\arguments{
\item{x}{vector of \code{x} values, should have same length
as \code{y}.}

\item{y}{vector of \code{y} values, should have same length
as \code{x}.}

\item{xlu}{vector of new \code{x} values given to interpolate
corresponding \code{y} values.}

\item{ylu}{vector of new \code{y} values given to interpolate
corresponding \code{x} values.}

\item{arrange}{sort data based on \code{x} or \code{y} values}

\item{asc}{wether to sort ascending (\code{TRUE}, default) or descending
(\code{FALSE}).}

\item{completename.x}{name to use for the \code{completevals} xlu
generated columns.}

\item{completename.y}{name to use for the \code{completevals} ylu
generated columns.}

\item{overwrite}{wether to overwrite original values (\code{TRUE}) or
not (\code{FALSE}, default) if given interpolation points exists in the
original data.}
}
\description{
Interpolation function
}
\details{
This function interpolate via \code{spline} missing values in a
two dimensional array, where one column ascends while the other
descends in value.
}
\examples{
##- example data
my.x <- seq(40, 0, -4)
my.x

my.y <- seq(0, 20, 2)
my.y

myData <- data.frame(x = my.x, y = my.y)
myData

##- example `xlu'
my.xlu <- c(11, 15, 25)

##- example `ylu'
my.ylu <- c(15, 5, 9) # note that values can be unordered

##- interpolation
new.y <- interp(x = my.x, y = my.y, xlu = my.xlu) # interp missing ylu
new.y$intvalues # interpolated rows
new.y$datares # interpolated rows appended to original dataframe
new.y$completevals

new.x <- interp(x = my.x, y = my.y, ylu = my.ylu) # interp missing xlu
new.x$intvalues # interpolated rows
new.x$datares # interpolated rows appended to original dataframe
new.x$completevals

##- both interpolation at the same time
interp(x = my.x, y = my.y, xlu = my.xlu, ylu = my.ylu,
       arrange = my.y, asc = TRUE)

interp(x = my.x, y = my.y, xlu = my.xlu, ylu = my.ylu,
       arrange = my.x, asc = TRUE, completename.x = "dlu")

##- when overwrite = TRUE a warning is noted
interp(x = my.x, y = my.y, ylu = c(14,11), overwrite = TRUE)
interp(x = my.x, y = my.y, xlu = c(28, 15), overwrite = TRUE)
interp(x = my.x, y = my.y, xlu = c(28, 15), ylu = c(14,11), overwrite = TRUE)

}
\author{
Christian Salas-Eljatib and Nicolás Campos
}
