% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_factor.R
\name{target_encode}
\alias{target_encode}
\title{Target encode}
\usage{
target_encode(data_set, target_encoding, drop = FALSE, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{target_encoding}{result of function \code{\link{build_target_encoding}} (list)}

\item{drop}{Should \code{col_to_encode} be dropped after generation (logical, default to FALSE)}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
\code{data_set} with new cols of \code{target_encoding} merged to \code{data_set}
using \code{target_encoding} names as merging key. \code{data_set} is edited by \strong{reference}.
}
\description{
Target encoding is the process of replacing a categorical value with the aggregation of the target variable.
the target variable. \code{target_encode} is used to apply this transformations on a data set.
Function \code{\link{build_target_encoding}} must be used first to compute aggregations.
}
\examples{
# Build a data set
require(data.table)
data_set <- data.table(student = c("Marie", "Marie", "Pierre", "Louis", "Louis"),
                      grades = c(1, 1, 2, 3, 4))

# Construct encoding
target_encoding <- build_target_encoding(data_set, cols_to_encode = "student",
                                         target_col = "grades", functions = c("mean", "sum"))

# Apply them
target_encode(data_set, target_encoding = target_encoding)
}
