% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_morse.R
\name{import_morse}
\alias{import_morse}
\alias{morse}
\title{Import \code{morse} model parameters}
\usage{
import_morse(
  fit,
  find_sd = TRUE,
  find_it = TRUE,
  reset_hb = FALSE,
  params = c("estim", "all"),
  mcmc_size,
  find.SD = deprecated(),
  find.IT = deprecated(),
  reset.hb = deprecated(),
  mcmc.size = deprecated(),
  file = deprecated()
)

morse(...)
}
\arguments{
\item{fit}{Either a string with a file path to an \emph{.Rdata} or \emph{.RDS} file
containing a \emph{morse} fit, or a \emph{morse} fit object itself}

\item{find_sd}{a logical value. If \code{TRUE}, it will try to find fitted parameters of a \emph{GUTS-RED-SD} model}

\item{find_it}{a logical value. If \code{TRUE}, it will try to find fitted parameters of a \emph{GUTS-RED-IT} model}

\item{reset_hb}{a logical value. If \code{TRUE}, the background hazard rate \code{hb} is set to zero}

\item{params}{\code{character}, if set to \code{"estim"} then only the best-fit parameters are
imported, else all parameter sets in the MCM chains are returned}

\item{mcmc_size}{optional \code{integer}, sets the maximum number of imported parameter sets per MCMC.
By default, all MSMS parameter samples are imported.}

\item{find.SD}{\emph{deprecated}\verb{,} alias for parameter \code{find_sd}}

\item{find.IT}{\emph{deprecated}\verb{,} alias for parameter \code{find_it}}

\item{reset.hb}{\emph{deprecated}\verb{,} alias for parameter \code{rest_hb}}

\item{mcmc.size}{\emph{deprecated}\verb{,} alias for parameter \code{mcmc_size}}

\item{file}{\emph{deprecated}\verb{,} alias for parameter \code{fit}}

\item{...}{Arguments passed on to \code{import_morse()}}
}
\value{
list of \link{parameter_set} objects
}
\description{
Loads GUTS model parameters which were fitted by the morse package.
}
\section{Functions}{
\itemize{
\item \code{morse()}: deprecated alias

}}
\examples{
# import all parameter fits
try(import_morse("path/to/morse_fit.RData"))

# import parameters for a specific model
try(import_morse("path/to/morse_fit.RData", find_it=TRUE, find_sd=FALSE))

# modify model objects
try(models \%>\% set_param(import_morse("path/to/morse_fit.RData")))
}
