% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{voxelize}
\alias{voxelize}
\title{Voxelization of functions}
\usage{
voxelize(f, from, to, by)
}
\arguments{
\item{f}{A parametrized function as a list containing a vector
"args" (arguments), and a matrix "vals" (values, d columns).}

\item{from}{A vector of d numbers, each giving a starting discretization
point for one dimension.}

\item{to}{A vector of d numbers, each giving a finishing discretization
point for one dimension.}

\item{by}{A vector of d numbers, each giving discretization step for one
dimension.}
}
\value{
A list containing two matrices: "voxels" with rows being voxel
numbers, and "coords" with rows being coordinates of voxel centers.
}
\description{
Convertes a pice-wise linear parametrized funtion into a discretized
voxel representation.
}
\examples{
library(curveDepth)
# Create some data based on growth curves
g1d <- dataf.growth()
g3d <- list("")
set.seed(1)
for (i in 1:length(g1d$dataf)){
  g3d[[i]] <- list(
    args = g1d$dataf[[1]]$args,
    vals = cbind(g1d$dataf[[i]]$vals,
                 g1d$dataf[[i]]$vals[length(g1d$dataf[[i]]$vals):1],
                 rnorm(length(g1d$dataf[[i]]$vals), sd = 1) +
                   rnorm(1, mean = 0, sd = 10)))
}
# Define voxels' bounds and resolution
from <- c(65, 65, -25)
to <- c(196, 196, 25)
steps <- 100
by <- (to - from) / steps
# Voxelize all curves
fs <- list("")
for (i in 1:length(g3d)){
  fs[[i]] <- voxelize(g3d[[i]], from, to, by)
}
\dontrun{
# Plot first 10 curves
library(rgl)
rgl.open()
rgl.bg(color = "white")
for (i in 1:10){
  spheres3d(fs[[i]]$voxels[, 1], fs[[i]]$voxels[, 2], fs[[i]]$voxels[, 3],
            col = "red", radius = 0.5)
}}
}
\references{
Lafaye De Micheaux, P., Mozharovskyi, P. and Vimond, M. (2018).
Depth for curve data and applications.
}
