% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{images2curves}
\alias{images2curves}
\title{Convert images to curves}
\usage{
images2curves(images)
}
\arguments{
\item{images}{A 3-dimensional array with each slice (matrix in first two
dimensions) corresponding to an image. Each (eps-strictly) positive
entry is regarded as an occupied pixel (one), otherwise it is regarded
as an empty pixel, of an image.}
}
\value{
A list of curves where each element is a function being a list
containing a matrix \code{coords} (curve's values, d columns).
}
\description{
Converts images to curves with points sorted in traversing order.
}
\examples{
library(curveDepth)
# Pixel-grid filling function for an image
plotGridImage <- function(dims){
  redDims1 <- dims[1] - 1
  redDims2 <- dims[2] - 1
  for (i in 1:(dims[1] - 1)){
    lines(c(i / redDims1 - 0.5 / redDims1,
            i / redDims1 - 0.5 / redDims1),
            c(0 - 0.5 / redDims2, 1 + 0.5 / redDims2),
            lwd = 1, lty = 3, col = "lightgray")
    lines(c(0 - 0.5 / redDims1, 1 + 0.5 / redDims1),
          c(i / redDims2 - 0.5 / redDims2,
            i / redDims2 - 0.5 / redDims2),
            lwd = 1, lty = 3, col = "lightgray")
  }
  rect(0 - 0.5 / redDims1, 0 - 0.5 / redDims2,
       1 + 0.5 / redDims1, 1 + 0.5 / redDims2)
}
# Pixel-grid filling function for a curve
plotGridCurve <- function(dims){
  for (i in 1:(dims[1] - 1)){
    lines(c(i / dims[1], i / dims[1]), c(0, 1),
          lwd = 1, lty = 3, col = "lightgray")
    lines(c(0, 1), c(i / dims[2], i / dims[2]),
          lwd = 1, lty = 3, col = "lightgray")
  }
  rect(0, 0, 1, 1)
}
# Load a digit and plot it
data("mnistShort017")
  aSevenDigit <- mnistShort017$`7`[, , 5]
image(as.matrix(rev(as.data.frame(aSevenDigit))),
      col = gray((255:0) / 256), asp = 1,
      xlim = c(0 - 1 / 27, 1 + 1 / 27),
      ylim = c(0 - 1 / 27, 1 + 1 / 27))
plotGridImage(dim(aSevenDigit)[1:2])
# Convert the digit to a curve and plot it
aSevenCurve <- images2curves(array(
  aSevenDigit, dim = c(28, 28, 1)))[[1]]
plot(cbind(aSevenCurve$coords[, 1],
           1 - aSevenCurve$coords[, 2]),
           type = "l", lwd = 3, asp = 1,
           xlim = c(0, 1), ylim = c(0, 1),
           xlab = "x", ylab = "y")
  plotGridCurve(dim(aSevenDigit)[1:2])
}
\references{
Lafaye De Micheaux, P., Mozharovskyi, P. and Vimond, M. (2018).
Depth for curve data and applications.
}
