% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle.R
\name{handle_cookies}
\alias{handle_cookies}
\title{Extract cookies from a handle}
\usage{
handle_cookies(handle)
}
\arguments{
\item{handle}{a curl handle object}
}
\description{
The \code{handle_cookies} function returns a data frame with 7 columns as specified in the
\href{http://www.cookiecentral.com/faq/#3.5}{netscape cookie file format}.
}
\examples{
h <- new_handle()
handle_cookies(h)

# Server sets cookies
req <- curl_fetch_memory("https://hb.cran.dev/cookies/set?foo=123&bar=ftw", handle = h)
handle_cookies(h)

# Server deletes cookies
req <- curl_fetch_memory("https://hb.cran.dev/cookies/delete?foo", handle = h)
handle_cookies(h)

# Cookies will survive a reset!
handle_reset(h)
handle_cookies(h)
}
\seealso{
Other handles: 
\code{\link{handle}}
}
\concept{handles}
