% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{step}
\alias{step}
\alias{given}
\alias{when}
\alias{then}
\title{Define a step}
\usage{
given(description, implementation)

when(description, implementation)

then(description, implementation)
}
\arguments{
\item{description}{A description of the step.

Cucumber executes each step in a scenario one at a time, in the sequence you’ve written them in.
When Cucumber tries to execute a step, it looks for a matching step definition to execute.

\strong{Keywords are not taken into account when looking for a step definition.}
This means you cannot have a \code{Given}, \code{When}, \code{Then}, \code{And} or \code{But} step with the same text as another step.

Cucumber considers the following steps duplicates:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Given there is money in my account
Then there is money in my account
}\if{html}{\out{</div>}}

This might seem like a limitation, but it forces you to come up with a less ambiguous, more clear domain language:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Given my account has a balance of £430
Then my account should have a balance of £430
}\if{html}{\out{</div>}}

To pass arguments, description can contain placeholders in curly braces.

To match:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Given my account has a balance of £430
}\if{html}{\out{</div>}}

use:

\if{html}{\out{<div class="sourceCode">}}\preformatted{given("my account has a balance of £\{float\}", function(balance, context) \{

\})
}\if{html}{\out{</div>}}

If no step definition is found an error will be thrown.

If multiple steps definitions for a single step are found an error will be thrown.}

\item{implementation}{A function that will be run during test execution.

The implementation function must always have the last parameter named \code{context}.
It holds the environment where test state can be stored to be passed to the next step.

If a step has a description \code{"I have {int} cucumbers in my basket"} then the implementation
function should be \verb{function(n, context)}. The \code{{int}} value will be passed to
\code{n}, this parameter can have any name.

If a table or a docstring is defined for a step, it will be passed as an argument after placeholder parameters
and before \code{context}. The function should be a \verb{function(n, table, context)}.
See
\href{https://github.com/jakubsob/cucumber/blob/main/inst/examples/table/tests/acceptance/setup-steps.R}{an example}
on how to write implementation that uses tables or docstrings.}
}
\value{
A function of class \code{step}, invisibly. Function should be called for side effects.
}
\description{
Provide a description that matches steps in feature files and the implementation function that will be run.
}
\details{
Placeholders in expressions are replaced with regular expressions that match values in the feature file.
Regular expressions are generated during runtime based on defined parameter types.

The expression \code{"I have {int} cucumbers in my basket"} will be converted to
\code{"I have [+-]?(?<![.])[:digit:]+(?![.]) cucumbers in my basket"}. The extracted value of \code{{int}}
will be passed to the implementation function after being transformed with \code{as.integer}.

To define your own parameter types use \code{\link{define_parameter_type}}.
}
\examples{
given("I have {int} cucumbers in my basket", function(n_cucumbers, context) {
  context$n_cucumbers <- n_cucumbers
})

given("I have {int} cucumbers in my basket and a table", function(n_cucumbers, table, context) {
  context$n_cucumbers <- n_cucumbers
  context$table <- table
})

when("I eat {int} cucumbers", function(n_cucumbers, context) {
  context$n_cucumbers <- context$n_cucumbers - n_cucumbers
})

then("I should have {int} cucumbers in my basket", function(n_cucumbers, context) {
  expect_equal(context$n_cucumbers, n_cucumbers)
})

}
\seealso{
\code{\link[=define_parameter_type]{define_parameter_type()}}
}
