% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_rscu}
\alias{est_rscu}
\title{Estimate Relative Synonymous Codon Usage (RSCU)}
\usage{
est_rscu(
  cf,
  weight = 1,
  pseudo_cnt = 1,
  codon_table = get_codon_table(),
  level = "subfam",
  incl_stop = FALSE
)
}
\arguments{
\item{cf}{A matrix of codon frequencies as calculated by \code{count_codons()}.
Rows represent sequences and columns represent codons.}

\item{weight}{A numeric vector of the same length as the number of sequences 
in \code{cf}, providing different weights for sequences when calculating 
codon frequencies. For example, gene expression levels. Default is 1 
(equal weights).}

\item{pseudo_cnt}{Numeric pseudo count added to avoid division by zero when 
few sequences are available for RSCU calculation (default: 1).}

\item{codon_table}{A codon table defining the genetic code, derived from 
\code{get_codon_table()} or \code{create_codon_table()}.}

\item{level}{Character string specifying the analysis level: "subfam" (default, 
analyzes codon subfamilies) or "amino_acid" (analyzes at amino acid level).}

\item{incl_stop}{Logical. Whether to include RSCU values for stop codons 
in the output (default: FALSE).}
}
\value{
A data.table containing the codon table with additional columns for 
  RSCU analysis: usage frequency counts (cts), frequency proportions (prop), 
  CAI weights (w_cai), and RSCU values (rscu). The table includes amino acid 
  codes, full amino acid names, codons, and subfamily classifications.
}
\description{
\code{est_rscu} calculates the Relative Synonymous Codon Usage (RSCU) values 
for codons, which quantify the bias in synonymous codon usage. RSCU values 
indicate whether a codon is used more (>1) or less (<1) frequently than 
expected under uniform usage within its synonymous group.
}
\examples{
# Calculate RSCU for all yeast genes
cf_all <- count_codons(yeast_cds)
rscu_all <- est_rscu(cf_all)
head(rscu_all)

# Calculate RSCU for highly expressed genes (top 500)
heg <- head(yeast_exp[order(-yeast_exp$fpkm), ], n = 500)
cf_heg <- count_codons(yeast_cds[heg$gene_id])
rscu_heg <- est_rscu(cf_heg)
head(rscu_heg)

}
\references{
Sharp PM, Tuohy TM, Mosurski KR. 1986. Codon usage in yeast: cluster analysis clearly differentiates highly and lowly expressed genes. Nucleic Acids Res 14:5125-5143.
}
