% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{check_cds}
\alias{check_cds}
\title{Quality control and preprocessing of coding sequences}
\usage{
check_cds(
  seqs,
  codon_table = get_codon_table(),
  min_len = 6,
  check_len = TRUE,
  check_start = TRUE,
  check_stop = TRUE,
  check_istop = TRUE,
  rm_start = TRUE,
  rm_stop = TRUE,
  start_codons = c("ATG")
)
}
\arguments{
\item{seqs}{Input CDS sequences as a DNAStringSet or compatible object.}

\item{codon_table}{Codon table matching the genetic code of the input sequences.
Generated using \code{get_codon_table()} or \code{create_codon_table()}.}

\item{min_len}{Minimum CDS length in nucleotides (default: 6).}

\item{check_len}{Logical. Check whether CDS length is divisible by 3 (default: TRUE).}

\item{check_start}{Logical. Check whether CDSs begin with valid start codons (default: TRUE).}

\item{check_stop}{Logical. Check whether CDSs end with valid stop codons (default: TRUE).}

\item{check_istop}{Logical. Check for internal stop codons (default: TRUE).}

\item{rm_start}{Logical. Remove start codons from the sequences (default: TRUE).}

\item{rm_stop}{Logical. Remove stop codons from the sequences (default: TRUE).}

\item{start_codons}{Character vector specifying valid start codons (default: "ATG").}
}
\value{
A DNAStringSet containing filtered and optionally trimmed CDS sequences 
  that pass all quality control checks.
}
\description{
\code{check_cds} performs comprehensive quality control on coding sequences (CDS) 
by filtering sequences based on various criteria and optionally removing start 
or stop codons. This function ensures that sequences meet the requirements for 
downstream codon usage analysis.
}
\examples{
# Perform CDS sequence quality control for a sample of yeast genes
s <- head(yeast_cds, 10)
print(s)
check_cds(s)

}
