% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{chemical_contains}
\alias{chemical_contains}
\title{Chemical contains}
\usage{
chemical_contains(
  word = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE,
  top = NULL
)
}
\arguments{
\item{word}{A character string of a chemical identifier or portion of a chemical
identifier. Identifiers can be a chemical name, dtxsid, dtxcid, casrn, or inchikey.}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}

\item{top}{The number of results to return if there are multiple results
available}
}
\value{
A data.frame of chemicals and related values matching the query
parameters
}
\description{
Chemical contains
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemicals that contain substring
substring_chemicals <- chemical_contains(word = 'TXSID702018')
\dontshow{\}) # examplesIf}
}
\author{
Paul Kruse, Kristin Issacs
}
