% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symm_fit_ind_noAssumption.R
\name{symm_fit_ind_EM_noAssumption}
\alias{symm_fit_ind_EM_noAssumption}
\title{symm_fit_ind_noAssumption.R}
\usage{
symm_fit_ind_EM_noAssumption(
  testStats,
  initMuList,
  initPiList,
  sameDirAlt = FALSE,
  eps = 10^(-5),
  checkpoint = TRUE
)
}
\arguments{
\item{testStats}{J*K matrix of test statistics where J is the number of sets and K is number of elements in each set.}

\item{initMuList}{List of 2^K elements where each element is a matrix with K rows and number of columns equal to the number of possible mean vectors for that binary representation.}

\item{initPiList}{List of 2^K elements where each element is a vector with number of elements equal to the number of possible mean vectors for that binary representation.}

\item{sameDirAlt}{Boolean, set to TRUE for replication testing, which uses a smaller alternative space.}

\item{eps}{Scalar, stop the EM algorithm when L2 norm of difference in parameters is less than this value.}

\item{checkpoint}{Boolean, set to TRUE to print iterations of EM}
}
\value{
A list with the elements:
\item{muInfo}{List with same dimensions as initMuList, holds the final mean parameters.}
\item{piInfo}{List with same dimensions as initPiList, holds the final mixture proportions}
\item{iter}{Number of iterations run in EM algorithm.}
\item{lfdrResults}{J*1 vector of all lfdr statistics.}
}
\description{
Fit the conditionally symmetric multidimensional Gaussian mixture model for sets of independent elements,
but we don't assume that the means in the composite alternative are greater in magnitude than those in the composite null.
}
\examples{
set.seed(0)
testStats <- cbind(rnorm(10^4), rnorm(10^4))
testStats[1:200, 1] <- rnorm(100, mean=3)
testStats[201:400, 1] <- rnorm(100, mean=5)
testStats[401:600, 2] <- rnorm(100, mean=3)
testStats[601:800, 2] <- rnorm(100, mean=5)
testStats[801:1000, 1:2] <- rnorm(200, mean=7)
initMuList <- list(matrix(data=0, nrow=2, ncol=1), matrix(data=c(0, 3, 0, 5), nrow=2, ncol=2),
matrix(data=c(3, 0, 5, 0), nrow=2, ncol=2), matrix(data=c(7, 7), nrow=2, ncol=1))
initPiList <- list(c(0.9), c(0.02, 0.02),c(0.02, 0.02), c(0.02))
results <- symm_fit_ind_EM_noAssumption(testStats = testStats,
initMuList = initMuList, initPiList = initPiList)

}
