% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mcap.R
\name{get_mktcap}
\alias{get_mktcap}
\title{Get the global market capitalization}
\usage{
get_mktcap(
  interval = "1d",
  from = NULL,
  to = NULL,
  altcoin = FALSE,
  reported = FALSE
)
}
\arguments{
\item{interval}{A \link{character}-vector of \link{length} 1. \verb{1d} by default.
See \code{\link[=available_intervals]{available_intervals()}} for available intervals.}

\item{from}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{altcoin}{A \link{logical}-vector of \link{length} 1. \link{FALSE} by default. Returns altcoin market capitalization
if \link{TRUE}}

\item{reported}{A \link{logical}-vector of \link{length} 1. \link{FALSE} by default. Returns reported volume if \link{TRUE}.}
}
\value{
An <[\link[xts]{xts}]>-object containing,

\item{index}{<\link{POSIXct}> The time-index}
\item{marketcap}{<\link{numeric}> Market capitalization}
\item{volume}{<\link{numeric}> Trading volume}
}
\description{
The \code{\link[=get_mktcap]{get_mktcap()}}-functions returns the global cryptocurrency market capitalization.
}
\details{
\subsection{On time-zones and dates}{

Values passed to \verb{from`` or }to\verb{must be coercible by [as.Date()], or [as.POSIXct()], with a format of either}"\%Y-\%m-\%d"\code{or}"\%Y-\%m-\%d \%H:\%M:\%S"`. By default all dates are passed and
returned with \code{\link[=Sys.timezone]{Sys.timezone()}}.
}

\subsection{On returns}{

If only \code{from} is provided 200 pips are returned up to \code{Sys.time()}.
If only \code{to} is provided 200 pips up to the specified date is returned.
}
}
\examples{
\dontrun{
  # script start;

  # get quote on
  # BTCUSDT pair from
  # Binance in 30m
  # intervals from the
  # last 24 hours
  tail(
    BTC <- cryptoQuotes::get_quote(
      ticker   = 'BTCUSDT',
      source   = 'binance',
      interval = '30m',
      futures  = FALSE,
      from     = Sys.Date() - 1
    )
  )

  # script end;
}
}
\seealso{
Other get-functions: 
\code{\link{get_fgindex}()},
\code{\link{get_fundingrate}()},
\code{\link{get_lsratio}()},
\code{\link{get_openinterest}()}
}
\author{
Serkan Korkmaz
}
