% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{mv}
\alias{mv}
\alias{mkdir}
\title{Functions to manipulate variables' or project's folder structure}
\usage{
mv(x, what, path)

mkdir(x, path)
}
\arguments{
\item{x}{A \code{CrunchDataset} or \code{Folder} (\code{VariableFolder} or \code{ProjectFolder})}

\item{what}{A Variable, selection of variables from \code{dataset}, or any
other object that can be moved to a folder (e.g. a dataset when organizing
projects).}

\item{path}{A character "path" to the folder: either a
vector of nested folder names or a single string with nested folders
separated by a delimiter ("/" default, configurable via
\code{options(crunch.delimiter)}). The path is interpreted as
relative to the location of the folder \code{x} (when \code{x} is a dataset, that
means the root, top-level folder). \code{path} may also be a \code{Folder} object.}
}
\value{
\code{x}, with the folder at \code{path} guaranteed to be created, and for
\code{mv}, containing \code{what} moved into it.
}
\description{
Variables in Crunch datasets are organized into folders, like in a file
system. Datasets are similarly organized into hierarchical Projects.
These functions allow you to create new folders and move objects into
folders. Their names, \code{mv} and \code{mkdir}, suggest their Unix file utility
inspiration.
}
\details{
The functions have some differences from the strict behavior of their Unix
ancestors. For one, they work recursively, without additional arguments:
\code{mkdir} will make every directory necessary to construct the requested path,
even if all parent directories didn't already exist; and \code{mv} doesn't
require that the directory to move to already exist---it will effectively
call \code{mkdir} along the way.
}
\examples{
\dontrun{
ds <- loadDataset("Example survey", project = "Studies")
ds <- mv(ds, c("gender", "age", "educ"), "Demographics")
ds <- mkdir(ds, "Key Performance Indicators/Brand X")
# These can also be chained together
require(magrittr)
ds <- ds \%>\%
    mv(c("aware_x", "nps_x"), "Key Performance Indicators/Brand X") \%>\%
    mv(c("aware_y", "nps_y"), "Key Performance Indicators/Brand Y")
# Can combine with cd() and move things with relative paths
ds \%>\%
    cd("Key Performance Indicators/Brand X") \%>\%
    mv("nps_x", "../Net Promoters")
# Can combine with folder() to move objects to the same place as something else
ds \%>\% mv("nps_y", folder(ds$nps_x))
# Now let's put ds in a Project
projects() \%>\%
    mv(ds, "Brand Tracking Studies")
}
}
\seealso{
\code{\link[=cd]{cd()}} to select a folder by path; \code{\link[=rmdir]{rmdir()}} to delete a folder;
\code{\link[=folder]{folder()}} to identify and set an object's parent folder;
\code{\link[base:files2]{base::dir.create()}}
if you literally want to create a directory in your local file system, which
\code{mkdir()} does not do
}
