% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{get_label}
\alias{get_label}
\title{Get label if wanted and available, or default (name) otherwise}
\usage{
get_label(x, default = names(x), object = FALSE, simplify = TRUE)
}
\arguments{
\item{x}{labelled object. If \code{x} is a list/data.frame, \code{get_label()} will return the labels of all children recursively}

\item{default}{value returned if there is no label. Default to \code{names(x)}.}

\item{object}{if \code{x} is a list/data.frame, \code{object=TRUE} will force getting the labels of the object instead of the children}

\item{simplify}{if \code{x} is a list and \code{object=FALSE}, simplify the result to a vector}
}
\value{
A character vector if \code{simplify==TRUE}, a list otherwise
}
\description{
Get label if wanted and available, or default (name) otherwise
}
\examples{
xx=mtcars2 \%>\%
  set_label("The mtcars2 dataset", object=TRUE)
xx$cyl=remove_label(xx$cyl)

#vectors
get_label(xx$mpg) #label="Miles/(US) gallon"
get_label(xx$cyl) #default to NULL (since names(xx$cyl)==NULL)
get_label(xx$cyl, default="Default value")

#data.frames
get_label(xx)
get_label(xx, object=TRUE)
data.frame(name=names(xx), label=get_label(xx, default=NA)) #cyl is NA

#lists
get_label(list(xx$cyl, xx$mpg))          #cyl is NA
get_label(list(foo=xx$cyl, bar=xx$mpg))  #default to names
get_label(list(foo=xx$cyl, bar=xx$mpg), default="Default value")
}
\seealso{
\code{\link[=set_label]{set_label()}}, \code{\link[=import_labels]{import_labels()}}, \code{\link[=remove_label]{remove_label()}}, \code{\link[Hmisc:label]{Hmisc::label()}}, \code{\link[expss:var_lab]{expss::var_lab()}}
}
\author{
Dan Chaltiel
}
