% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{crosstable_effect_args}
\alias{crosstable_effect_args}
\title{Default arguments for calculating and displaying effects in \code{\link[=crosstable]{crosstable()}}}
\usage{
crosstable_effect_args(
  effect_summarize = diff_mean_auto,
  effect_tabular = effect_odds_ratio,
  effect_survival = effect_survival_coxph,
  effect_display = display_effect,
  conf_level = 0.95,
  digits = 2
)
}
\arguments{
\item{effect_summarize}{a function of three arguments (continuous variable, grouping variable and conf_level), used to compare continuous variable. Returns a list of five components: \code{effect} (the effect value(s)), \code{ci} (the matrix of confidence interval(s)), \code{effect.name} (the interpretation(s) of the effect value(s)), \code{effect.type} (the description of the measure used) and \code{conf_level} (the confidence interval level). Users can use \code{\link[=diff_mean_auto]{diff_mean_auto()}}, \code{\link[=diff_mean_student]{diff_mean_student()}}, \code{\link[=diff_mean_boot]{diff_mean_boot()}}, or \code{\link[=diff_median]{diff_median()}}, or their custom own function.}

\item{effect_tabular}{a function of three arguments (two categorical variables and conf_level) used to measure the associations between two factors. Returns a list of five components: \code{effect} (the effect value(s)), \code{ci} (the matrix of confidence interval(s)), \code{effect.name} (the interpretation(s) of the effect value(s)), \code{effect.type} (the description of the measure used) and \code{conf_level} (the confidence interval level).Users can use \code{\link[=effect_odds_ratio]{effect_odds_ratio()}}, \code{\link[=effect_relative_risk]{effect_relative_risk()}}, or \code{\link[=effect_risk_difference]{effect_risk_difference()}}, or their custom own function.}

\item{effect_survival}{a function of two argument (a formula and conf_level), used to measure the association between a censored and a factor. Returns the same components as created by \code{effect_summarize}.Users can use \code{\link[=effect_survival_coxph]{effect_survival_coxph()}} or their custom own function.}

\item{effect_display}{a function to format the effect. See \code{\link[=display_effect]{display_effect()}}.}

\item{conf_level}{the desired confidence interval level}

\item{digits}{the decimal places}
}
\value{
A list with effect parameters
}
\description{
This helper function provides default parameters for defining how the effect sizes should be computed. It belongs to the \code{effect_args} argument of the \code{\link[=crosstable]{crosstable()}} function. See \link{effect_summary}, \link{effect_tabular}, and \link{effect_survival} for more insight.
}
\author{
Dan Chaltiel
}
