% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_monitor_aws_batch.R
\name{crew_monitor_aws_batch}
\alias{crew_monitor_aws_batch}
\title{Create an AWS Batch monitor object.}
\usage{
crew_monitor_aws_batch(
  job_queue,
  job_definition,
  log_group = "/aws/batch/job",
  config = NULL,
  credentials = NULL,
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{job_queue}{Character vector of names of AWS Batch job queues.
As of \code{crew.aws.batch} version 0.0.8 and above, you can supply
more than one job queue. Methods like \code{jobs()} and \code{active()}
will query all the job queues given.}

\item{job_definition}{Character string, name of the AWS Batch
job definition.}

\item{log_group}{Character of length 1,
AWS Batch CloudWatch log group to get job logs.
The default log group is often \code{"/aws/batch/job"}, but not always.
It is not easy to get the log group of an active job or job
definition, so if you have a non-default log group and you do not
know its name, please consult your system administrator.}

\item{config}{Optional named list, \code{config} argument of
\code{paws.compute::batch()} with optional configuration details.}

\item{credentials}{Optional named list. \code{credentials} argument of
\code{paws.compute::batch()} with optional credentials (if not already
provided through environment variables such as \code{AWS_ACCESS_KEY_ID}).}

\item{endpoint}{Optional character of length 1. \code{endpoint}
argument of \code{paws.compute::batch()} with the endpoint to send HTTP
requests.}

\item{region}{Character of length 1. \code{region} argument of
\code{paws.compute::batch()} with an AWS region string such as \code{"us-east-2"}.
Serves as the region for both AWS Batch and CloudWatch. Tries to
default to \code{paws.common::get_config()$region}, then to
\code{Sys.getenv("AWS_REGION")} if unsuccessful, then
\code{Sys.getenv("AWS_REGION")}, then \code{Sys.getenv("AWS_DEFAULT_REGION")}.}
}
\description{
Create an \code{R6} object to list, inspect, and terminate
AWS Batch jobs.
}
\section{IAM policies}{

In order for the AWS Batch \code{crew} monitor class to function
properly, your IAM policy needs permission to perform the \code{SubmitJob},
\code{TerminateJob}, \code{ListJobs}, and \code{DescribeJobs} AWS Batch API calls.
In addition, to download CloudWatch logs with the \code{log()} method,
your IAM policy also needs permission to perform the \code{GetLogEvents}
CloudWatch logs API call.
For more information on AWS policies and permissions, please visit
\url{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}.
}

\seealso{
Other monitor: 
\code{\link{crew_class_monitor_aws_batch}}
}
\concept{monitor}
