% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_color_crayons}
\alias{scale_color_crayons}
\alias{scale_fill_crayons}
\alias{scale_colour_crayons}
\title{Crayon Color Scales for \code{ggplot2}}
\usage{
scale_color_crayons(palette = "standard16", which = NULL, ..., reverse = FALSE)

scale_fill_crayons(palette = "standard16", which = NULL, ..., reverse = FALSE)

scale_colour_crayons(
  palette = "standard16",
  which = NULL,
  ...,
  reverse = FALSE
)
}
\arguments{
\item{palette}{palette from \code{names(crayons)} to use}

\item{which}{numeric indices of colors to use. \code{NULL} by default.}

\item{...}{arguments passed on to \code{ggplot2::discrete_scale()}}

\item{reverse}{Should the vector be reversed? Default is \code{FALSE}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale}
}
\description{
Crayon Color Scales for \code{ggplot2}
}
\examples{
library(ggplot2)
ggplot2::mpg |>
  ggplot() +
   geom_point(aes(displ, hwy, colour = class)) +
   scale_color_crayons(palette = 'original')

ggplot2::mpg |>
  ggplot() +
   geom_point(aes(displ, hwy, fill = class), pch = 23, color = 'transparent') +
   scale_fill_crayons(palette = 'original')

}
