% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_header_rm_md.R
\name{modify_header_rm_md}
\alias{modify_header_rm_md}
\title{Remove Markdown Syntax from Header}
\usage{
modify_header_rm_md(x, md = "bold", type = "star")
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary table}

\item{md}{(\code{character})\cr
Must be one or more of \code{'bold'} and \code{'italic'}. Default is \code{'bold'}.}

\item{type}{(\code{character})\cr
Must be one or more of \code{'star'} and \code{'underscore'}. Default is \code{'star'}.}
}
\value{
gtsummary table
}
\description{
Remove markdown syntax (e.g. double star for bold, underscore for italic, etc)
from the headers and spanning headers of a gtsummary table.
}
\examples{
tbl_roche_summary(
  data = cards::ADSL,
  include = AGE,
  by = ARM,
  nonmissing = "always"
) |>
  modify_header_rm_md()
}
