% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_transformations.r
\name{udpipe_simplify}
\alias{udpipe_simplify}
\title{Simplify tokenIndex created with the udpipe parser}
\usage{
udpipe_simplify(
  tokens,
  split_conj = T,
  rm_punct = F,
  new_sentences = F,
  rm_mark = F
)
}
\arguments{
\item{tokens}{A tokenIndex, based on output from the ud parser.}

\item{split_conj}{If TRUE, split conjunctions into separate sentences}

\item{rm_punct}{If TRUE, remove punctuation afterwards}

\item{new_sentences}{If TRUE, assign new sentence and token_id after splitting}

\item{rm_mark}{If TRUE, remove children with a mark relation if this is used in the simplification.}
}
\value{
a tokenIndex
}
\description{
This is an off-the-shelf implementation of several rsyntax transformation for 
simplifying text.
}
\examples{
if (interactive()) {
tc = tc_sotu_udpipe$copy()
tc2 = transform_rsyntax(tc, udpipe_simplify)

browse_texts(tc2)
   rsyntax::plot_tree(tc_sotu_udpipe$tokens, token, lemma, POS, sentence_i=20)
   rsyntax::plot_tree(tc2$tokens, token, lemma, POS, sentence_i=20)
}
}
