% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_results.r
\name{plot.contextHits}
\alias{plot.contextHits}
\title{S3 plot for contextHits class}
\usage{
\method{plot}{contextHits}(x, min_weight = 0, backbone_alpha = NA, ...)
}
\arguments{
\item{x}{a contextHits object, as returned by \link{search_contexts}}

\item{min_weight}{Optionally, the minimum weight for an edge in the network}

\item{backbone_alpha}{Optionally, the alpha threshold for backbone extraction (similar to a p-value, and lower is more strict)}

\item{...}{not used}
}
\description{
S3 plot for contextHits class
}
\examples{
\dontrun{
tc = create_tcorpus(sotu_texts, doc_column='id')
hits = search_contexts(tc, c('War# war* OR army OR bomb*','Terrorism# terroris*',
                              'Economy# econom* OR bank*','Education# educat* OR school*'))

plot(hits)
}
}
