% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copheplots.R
\name{cophe_plot}
\alias{cophe_plot}
\title{cophe_plots showing the Ha and Hc of all traits and labelled above the specified threshold}
\usage{
cophe_plot(
  multi.dat,
  querysnpid,
  query_trait_names,
  thresh_Hc = 0.5,
  thresh_Ha = 0.5,
  beta_p = NULL,
  traits.dat = NULL,
  group_pheno = NULL
)
}
\arguments{
\item{multi.dat}{multi trait cophescan results returned from cophe.multitrait or multitrait.simplify}

\item{querysnpid}{query variant (only a single variant for PheWAS plots)}

\item{query_trait_names}{list of phenotype names}

\item{thresh_Hc}{Hc threshold to be displayed}

\item{thresh_Ha}{Ha threshold to be displayed}

\item{beta_p}{data.frame (from the \code{get.beta} function) with four columns : 1. "beta_plot": indicating beta direction (p or n) 2. "beta_plot": -log10(pval) of the queried variant 3. "querysnp" 4. "querytrait".}

\item{traits.dat}{list of multi-trait coloc structured datasets}

\item{group_pheno}{Vector with additional grouping of phenotypes}
}
\value{
cophescan plots of Ha and Hc
}
\description{
cophe_plots showing the Ha and Hc of all traits and labelled above the specified threshold
}
\seealso{
\code{\link{cophe.single}}, \code{\link{cophe.susie}}, \code{\link{cophe.multitrait}}, , \code{\link{multitrait.simplify}}
}
