% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-Date.R
\name{opts_Date}
\alias{opts_Date}
\title{Constructive options class 'Date'}
\usage{
opts_Date(
  constructor = c("as.Date", "as_date", "date", "new_date", "as.Date.numeric",
    "as_date.numeric", "next", "double"),
  ...,
  origin = "1970-01-01"
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{origin}{Origin to be used, ignored when irrelevant.}
}
\value{
An object of class <constructive_options/constructive_options_Date>
}
\description{
These options will be used on objects of class 'date'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"as.Date"} (default): We wrap a character vector with \code{as.Date()}, if the date
is infinite it cannot be converted to character and we wrap a numeric vector and
provide an \code{origin} argument.
\item \code{"as_date"} : Similar as above but using \code{lubridate::as_date()}, the only difference is
that we never need to supply \code{origin}.
\item \code{"date"} : Similar as above but using \code{lubridate::date()}, it doesn't support
infinite dates so we fall back on \code{lubridate::as_date()} when we encounter them.
\item \code{"new_date"} : We wrap a numeric vector with \code{vctrs::new_date()}
\item \code{"as.Date.numeric"} : We wrap a numeric vector with \code{as.Date()} and use the
provided \code{origin}
\item \code{"as_date.numeric"} : Same as above but using \code{lubridate::as_date()} and use the
provided \code{origin}
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"double"} : We define as an double vector and repair attributes
}

If the data is not appropriate for a constructor we fall back to another one
appropriately.
}
