% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itanalHelpers.R
\name{getCqItanalFacility}
\alias{getCqItanalFacility}
\title{getCqItanalFacility}
\usage{
getCqItanalFacility(itan)
}
\arguments{
\item{itan}{A list of class "cqItanal" created by \code{conquestr::getCqItanal()}}
}
\value{
A list.
}
\description{
returns an item facility for each item in itanal object created
by ACER ConQuest.
For a dichotomously scored Rasch-like item, facility is the percent correct.
For a polytomously scored item, or with estimated scores, facility is given by:
the sum of the number of cases in each response category, multiplied by the score for that category
divided by the sum of all cases responding to the items times the maximum score for the item.
}
\examples{
mySys <- ConQuestSys()
myItan <- getCqItanal(mySys)
getCqItanalFacility(myItan)
}
