% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/dbi_methods.R,
%   R/fs_methods.R, R/logger_generics.R
\name{write_cnt}
\alias{write_cnt}
\alias{write_cnt.ConnectorDBI}
\alias{write_cnt.ConnectorFS}
\alias{write_cnt.ConnectorLogger}
\title{Write content to the connector}
\usage{
write_cnt(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{write_cnt}{ConnectorDBI}(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{write_cnt}{ConnectorFS}(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{write_cnt}{ConnectorLogger}(connector_object, x, name, ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{x}{The object to write to the connection}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{overwrite}{Overwrite existing content if it exists in the connector?
See \link{connector-options} for details. Default can be set globally with
\code{options(connector.overwrite = TRUE/FALSE)} or environment variable
\code{R_CONNECTOR_OVERWRITE}.. Default: \code{FALSE}.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to write content to the different connector objects:

\itemize{
\item \link{ConnectorDBI}: Uses \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}} to write the table to the DBI connection.
}

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[=write_file]{write_file()}} to Write a file based on the file extension.
The underlying function used, and thereby also the arguments available
through \code{...} depends on the file extension.
}

If no file extension is provided in the \code{name}, the default extension will be
automatically appended (configurable via \code{options(connector.default_ext = "csv")},
defaults to "csv").

\itemize{
\item \link{ConnectorLogger}: Logs the write operation and calls the underlying connector method.
}
}
\examples{
# Write table to DBI database
cnt <- connector_dbi(RSQLite::SQLite())

cnt |>
  list_content_cnt()

cnt |>
  write_cnt(iris, "iris")

cnt |>
  list_content_cnt()

# Write different file types to a file storage

folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connector_fs(folder)

cnt |>
  list_content_cnt(pattern = "iris")

# rds file
cnt |>
  write_cnt(iris, "iris.rds")

# CSV file
cnt |>
  write_cnt(iris, "iris.csv")

cnt |>
  list_content_cnt(pattern = "iris")

# Add logging to a database connector
cnt <- connectors(data = connector_dbi(RSQLite::SQLite())) |> add_logs()

cnt$data |>
  write_cnt(mtcars, "cars")

}
