% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_logger_databricks.R, R/connector_imports.R
\name{log_remove_connector.ConnectorDatabricksTable}
\alias{log_remove_connector.ConnectorDatabricksTable}
\alias{log_remove_connector.ConnectorDatabricksVolume}
\alias{log_remove_connector}
\title{Connector Logging Functions}
\usage{
\method{log_remove_connector}{ConnectorDatabricksTable}(connector_object, name, ...)

\method{log_remove_connector}{ConnectorDatabricksVolume}(connector_object, name, ...)

log_remove_connector(connector_object, name, ...)
}
\arguments{
\item{connector_object}{The connector object to log operations for. Can be
any connector class (ConnectorFS, ConnectorDBI, ConnectorLogger, etc.)}

\item{name}{Character string specifying the name or identifier of the
resource being operated on (e.g., file name, table name)}

\item{...}{Additional parameters passed to specific method implementations.
May include connector-specific options or metadata.}
}
\value{
These are primarily side-effect functions that perform logging. The actual
return value depends on the specific method implementation, typically:
\itemize{
\item \code{log_read_connector}: Result of the read operation
\item \code{log_write_connector}: Invisible result of write operation
\item \code{log_remove_connector}: Invisible result of remove operation
\item \code{log_list_content_connector}: List of connector contents
}
}
\description{
\itemize{
\item \link{ConnectorDatabricksTable}: Implementation of the \code{log_remove_connector}
function for the ConnectorDatabricksTable class.
}

\itemize{
\item \link{ConnectorDatabricksVolume}: Implementation of the \code{log_remove_connector}
function for the ConnectorDatabricksVolume class.
}

Additional log remove methods for Databricks connectors implemented for
\code{\link[connector:log-functions]{connector::log_remove_connector()}}:
}
\details{
Connector Logging Functions

The logging system is built around S3 generic functions that dispatch to
specific implementations based on the connector class. Each operation is
logged with contextual information including connector details, operation
type, and resource names.
}
