% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_imports.R, R/volume_methods.R
\name{download_cnt}
\alias{download_cnt}
\alias{download_cnt.ConnectorDatabricksVolume}
\title{Download content from the connector}
\usage{
download_cnt(connector_object, src, dest = basename(src), ...)

\method{download_cnt}{ConnectorDatabricksVolume}(connector_object, src, dest = basename(src), ...)
}
\arguments{
\item{connector_object}{\link[connector]{Connector} The connector object to use.}

\item{src}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{dest}{\link{character} Path to the file to download to or upload from}

\item{...}{\link{ConnectorDatabricksVolume}: Additional parameters to pass to the
\code{\link[brickster:db_volume_read]{brickster::db_volume_read()}} method}
}
\value{
\link{invisible} connector_object.
}
\description{
Additional list content methods for Databricks connectors implemented for
\code{\link[connector:download_cnt]{connector::download_cnt()}}:

\itemize{
\item \link{ConnectorDatabricksVolume}: Reuses the \code{\link[connector:download_cnt]{connector::download_cnt()}}
method for \link{ConnectorDatabricksVolume}, but always
sets the \code{catalog}, \code{schema} and \code{path} as defined in when initializing the
connector.
}
}
