% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_usage_static}
\alias{get_usage_static}
\title{Get usage information from deployed static content}
\usage{
get_usage_static(
  src,
  content_guid = NULL,
  min_data_version = NULL,
  from = NULL,
  to = NULL,
  limit = 500,
  previous = NULL,
  nxt = NULL,
  asc_order = TRUE
)
}
\arguments{
\item{src}{the source object}

\item{content_guid}{Filter results by content GUID}

\item{min_data_version}{Filter by data version. Records with a data version
lower than the given value will be excluded from the set of results.}

\item{from}{The timestamp that starts the time window of interest. Any usage
information that ends prior to this timestamp will not be returned.
Individual records may contain a starting time that is before this if they
end after it or have not finished. Must be of class Date or POSIX}

\item{to}{The timestamp that ends the time window of interest. Any usage
information that starts after this timestamp will not be returned.
Individual records may contain an ending time that is after this
(or no ending time) if they start before it. Must be of class Date or
POSIX}

\item{limit}{The number of records to return.}

\item{previous}{Retrieve the previous page of Shiny application usage
logs relative to the provided value. This value corresponds to an internal
reference within the server and should be sourced from the appropriate
attribute within the paging object of a previous response.}

\item{nxt}{Retrieve the next page of Shiny application usage logs
relative to the provided value. This value corresponds to an internal
reference within the server and should be sourced from the appropriate
attribute within the paging object of a previous response.}

\item{asc_order}{Defaults to TRUE; Determines if the response records
should be listed in ascending or descending order within the response.
Ordering is by the started timestamp field.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{content_guid}: The GUID, in RFC4122 format, of the Shiny
application this information pertains to.
\item \code{user_guid}: The GUID, in RFC4122 format, of the user that
visited the application.
\item \code{variant_key}: The key of the variant the user visited.
This will be null for static content.
\item \code{time}: The timestamp, in RFC3339 format, when the user
visited the content.
\item \code{rendering_id}: The ID of the rendering the user visited.
This will be null for static content.
\item \code{bundle_id}: The ID of the particular bundle used.
\item \code{data_version}: The data version the record was recorded
with. The Rendered and Static Content Visit Events section of the
Posit Connect Admin Guide explains how to interpret data_version
values.
}
}
\description{
This function retrieves usage information from static content
on the Posit Connect server (e.g. Rmarkdown, Jupyter Notebooks)
}
\details{
Please see https://docs.posit.co/connect/api/#get-/v1/instrumentation/content/visits
for more information.
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

from <- Sys.Date() - lubridate::days(5)
get_usage_static(client, limit = 20, from = from)
}

}
