% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncs.R
\name{ncs}
\alias{ncs}
\title{Given a set of embeddings and a set of tokenized contexts, find the top N nearest
contexts.}
\usage{
ncs(x, contexts_dem, contexts = NULL, N = 5, as_list = TRUE)
}
\arguments{
\item{x}{a (quanteda) \code{dem-class} or \code{fem-class} object.}

\item{contexts_dem}{a \code{dem-class} object corresponding to the ALC
embeddings of candidate contexts.}

\item{contexts}{a (quanteda) \code{tokens-class} object of
tokenized candidate contexts. Note, these must correspond to the same
contexts in \code{contexts_dem}. If NULL, then the context (document) ids
will be output instead of the text.}

\item{N}{(numeric) number of nearest contexts to return}

\item{as_list}{(logical) if FALSE all results are combined into a single data.frame
If TRUE, a list of data.frames is returned with one data.frame per embedding}
}
\value{
a \code{data.frame} or list of data.frames (one for each target)
with the following columns:
\describe{
\item{\code{target}}{ (character) rownames of \code{x},
the labels of the ALC embeddings. \code{NA} if \code{is.null(rownames(x))}.}
\item{\code{context}}{(character) contexts collapsed into single documents (i.e. untokenized).
If \code{contexts} is NULL then this variable will show the context (document) ids which
you can use to merge.}
\item{\code{rank}}{(character) rank of context in terms of similarity with \code{x}.}
\item{\code{value}}{(numeric) cosine similarity between \code{x} and context.}
}
}
\description{
Given a set of embeddings and a set of tokenized contexts, find the top N nearest
contexts.
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# build a tokenized corpus of contexts sorrounding a target term
immig_toks <- tokens_context(x = toks, pattern = "immigr*",
window = 6L, rm_keyword = FALSE)

# build document-feature matrix
immig_dfm <- dfm(immig_toks)

# construct document-embedding-matrix
immig_dem <- dem(immig_dfm, pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform, verbose = FALSE)

# to get group-specific embeddings, average within party
immig_wv_party <- dem_group(immig_dem, groups = immig_dem@docvars$party)

# find nearest contexts by party
# setting as_list = FALSE combines each group's
# results into a single data.frame (useful for joint plotting)
ncs(x = immig_wv_party, contexts_dem = immig_dem,
contexts = immig_toks, N = 5, as_list = TRUE)
}
\keyword{ncs}
