% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputePermutation.R
\name{CMImat2vecPermu}
\alias{CMImat2vecPermu}
\title{Permuted Normalized Conditional Mutual Information Between Matrix and Vector}
\usage{
CMImat2vecPermu(
  mat,
  vec,
  condi,
  bin = 6,
  sp_order = 2,
  bulkIdx = 0,
  permutationTimes = 1000,
  seedNum = 99999999
)
}
\arguments{
\item{mat}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{vec}{A numeric vector, with length equal to the number of columns in `mat`.}

\item{condi}{A numeric condition vector, matching the number of columns in `mat`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}

\item{bulkIdx}{Index to divide the task when processing many permutations. Default is 0.}

\item{permutationTimes}{Number of permutations for sampling. Default is 1000.}

\item{seedNum}{Seed for random number generation. Default is 99999999.}
}
\value{
A numeric vector of normalized conditional mutual information (CMI) values for each permutation.
}
\description{
Computes the conditional mutual information (CMI) between a random vector sampled from a matrix and a vector,
conditioned on a third vector, normalized by the mutual information of the vector with itself.
The sampling is done multiple times to generate a distribution.
}
\examples{
mat <- matrix(rnorm(10000), nrow = 100, ncol = 100)
vec <- rnorm(100)
condi <- rnorm(100)
CMImat2vecPermu(mat, vec, condi)

}
