% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_point_species.R
\name{inspect_point_species}
\alias{inspect_point_species}
\title{Inspect overlapping species at sampling points}
\usage{
inspect_point_species(
  traits_summary,
  point_ids = NULL,
  n_random = 10,
  lon_col = "Longitude",
  lat_col = "Latitude",
  ID_col = "ID",
  min_species_valid = 3,
  env_var = NULL
)
}
\arguments{
\item{traits_summary}{A list output from \code{summarize_traits_by_point()}, containing summarized trait values (\verb{$points}) and species overlaps (\verb{$overlap}).}

\item{point_ids}{Optional. A vector of specific point IDs to inspect. If NULL, selects \code{n_random} points at random.}

\item{n_random}{Number of random points to inspect if \code{point_ids} not provided (default = 10).}

\item{lon_col}{Name of the longitude column in \code{points} (default = "Longitude").}

\item{lat_col}{Name of the latitude column in \code{points} (default = "Latitude").}

\item{ID_col}{Name of the ID column in \code{points} (default = "ID").}

\item{min_species_valid}{Minimum number of species with trait data to consider a point valid (default = 3).}

\item{env_var}{Optional. Name of the environmental variable column in \code{points} to include in popup.}
}
\value{
An interactive leaflet map showing selected points with species list popups.
}
\description{
Creates an interactive map to verify species overlap at selected points.
}
\examples{
\donttest{
# Load sample data from the package
data("geoPoints", package = "commecometrics")
data("traits", package = "commecometrics")
data("spRanges", package = "commecometrics")

# Summarize traits at points
traitsByPoint <- summarize_traits_by_point(
  points_df = geoPoints,
  trait_df = traits,
  species_polygons = spRanges,
  trait_column = "RBL",
  species_name_col = "sci_name",
  continent = FALSE,
  parallel = FALSE
)

# Visualize a random sample of 10 points
inspect_point_species(
  traits_summary = traitsByPoint,
  n_random = 10,
  min_species_valid = 3
)
}
}
