% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c4a_plot.R
\name{c4a_plot}
\alias{c4a_plot}
\alias{c4a_plot_cvd}
\alias{c4a_plot_hex}
\title{Plot a color palette}
\usage{
c4a_plot(
  palette,
  ...,
  dark = FALSE,
  include.na = FALSE,
  hex = FALSE,
  include.cvd = FALSE,
  nrows = NA,
  ncols = NA
)

c4a_plot_cvd(...)

c4a_plot_hex(...)
}
\arguments{
\item{palette}{Palette name (see \code{\link{c4a}}) or a color vector}

\item{...}{arguments passed on to \code{\link{c4a}}}

\item{dark}{dark (black) background?}

\item{include.na}{should a color for missing values be included?}

\item{hex}{should hex codes be printed instead of color labels (or numbers)?}

\item{include.cvd}{should color deficiency simulated colors be included?}

\item{nrows, ncols}{Number of rows and columns. Ignored if \code{include.cvd = TRUE} (in that case, rows are used for the simulated colors). By default automatically calculated based on aspect ratio of the device.}
}
\value{
Besides the plot, a \code{\link[grid:gTree]{gTree}} is returned silently
}
\description{
Plot a color palette, either a cols4all palette, or a color vector. \code{c4a_plot_cvd} is a shortcut to include color-blind simulated colors, `c4a_plot_hex is a shortcut to print hex codes instead of labels.
}
\examples{
c4a_plot("brewer.set1", nrows=1)

c4a_plot_hex("brewer.set1", nrows=1)

c4a_plot_cvd("brewer.set1")

c4a_plot_cvd("greens")

c4a_plot_cvd("tol.pu_gn")

c4a_plot(.P$cols4all$bivs$pu_gn_bivs, n = 5)

c4a_plot(.P$met$bivc$monet)

c4a_plot(.P$cols4all$bivd$pu_gn_bivd, n = 5)

c4a_plot(.P$cols4all$bivg$gn_bivg, n = 5)
}
