% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_output.R
\name{get_cos_purity}
\alias{get_cos_purity}
\title{Calculate purity within and in-between CoS}
\usage{
get_cos_purity(cos, X = NULL, Xcorr = NULL, n_purity = 100)
}
\arguments{
\item{cos}{List of variables in CoS}

\item{X}{Genotype matrix of values of the p variables. Used to compute correlations if Xcorr is not provided.}

\item{Xcorr}{Correlation matrix of correlations between variables. Alternative to X.}

\item{n_purity}{The maximum number of CoS variables used in calculating the correlation (\dQuote{purity}) statistics.
When the number of variables included in the CoS is greater than this number, the CoS variables are randomly subsampled.}
}
\value{
A list containing three matrices (min_abs_cor, max_abs_cor, median_abs_cor) with
purity statistics for all pairs of CoS. Diagonal elements represent within-CoS purity.
}
\description{
Calculate purity statistics between all pairs of colocalization confidence sets (CoS)
}
\examples{
# colocboost example
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
colnames(X) <- paste0("SNP", 1:P)
L <- 3
true_beta <- matrix(0, P, L)
true_beta[10, 1] <- 0.5 
true_beta[10, 2] <- 0.4 
true_beta[50, 2] <- 0.3 
true_beta[80, 3] <- 0.6 
Y <- matrix(0, N, L)
for (l in 1:L) {
  Y[, l] <- X \%*\% true_beta[, l] + rnorm(N, 0, 1)
}
res <- colocboost(X = X, Y = Y)
cos_res <- get_cos(res, coverage = 0.8)
get_cos_purity(cos_res$cos, X = X)

}
\seealso{
Other colocboost_utilities: 
\code{\link{get_cormat}()},
\code{\link{get_cos}()},
\code{\link{get_cos_summary}()},
\code{\link{get_hierarchical_clusters}()},
\code{\link{get_ucos_summary}()}
}
\concept{colocboost_utilities}
