% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.r
\name{interaction_p_value}
\alias{interaction_p_value}
\title{Calculate interaction p-value}
\usage{
interaction_p_value(
  data,
  y,
  predictor,
  group_var,
  time = NULL,
  covars = NULL,
  rcs_knots = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string of the outcome variable. The variable should be binary or numeric and determines
the type of model to be used. If the variable is binary, logistic or Cox regression is used. If the variable is
numeric, linear regression is used.}

\item{predictor}{A character string of the predictor variable.}

\item{group_var}{A character string of the group variable. The variable should be categorical. If a
numeric variable is provided, it will be split by the median value.}

\item{time}{A character string of the time variable. If \code{NULL}, linear or logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{covars}{A character vector of covariate names.}

\item{rcs_knots}{The number of rcs knots. If \code{NULL}, a linear model would be fitted instead.}
}
\value{
A numerical, the interaction p-value
}
\description{
This function calculates the interaction p-value between a predictor and a group variable in a
linear, logistic, or Cox proportional hazards model.
}
\examples{
data(cancer, package = "survival")
interaction_p_value(
  data = cancer, y = "status", predictor = "age", group_var = "sex",
  time = "time", rcs_knots = 4
)
}
