% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotwin.R
\name{plotwin}
\alias{plotwin}
\title{Plot the start and end time of best climate windows}
\usage{
plotwin(dataset, cw = 0.95)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{slidingwin}}.}

\item{cw}{Cumulative model weight used to subset the group of best models.}
}
\value{
Creates two boxplots showing the start and end time for a subset
 of best climate windows. Best climate windows make up the
 cumulative model weight equivalent to the value of cw.
}
\description{
Visualise the start and end time for a subset of best climate windows.
}
\examples{
# View window limits for climate windows in the top 95\% of model weights.

data(MassOutput)

plotwin(dataset = MassOutput, cw = 0.95)

}
\author{
Liam D. Bailey and Martijn van de Pol
}
