% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_stations_noaa.R
\name{nearest_stations_noaa}
\alias{nearest_stations_noaa}
\title{List of nearby SYNOP stations for a defined geographical location}
\usage{
nearest_stations_noaa(
  country,
  date = Sys.Date(),
  add_map = TRUE,
  point = NULL,
  no_of_stations = 10,
  allow_failure = TRUE
)
}
\arguments{
\item{country}{country name (e.g., "SRI LANKA"). Single entries allowed only.}

\item{date}{optionally, a day when measurements were done in all available locations; current Sys.Date used by default}

\item{add_map}{logical - whether to draw a map for a returned data frame (requires maps/mapdata packages)}

\item{point}{a vector of two coordinates (longitude, latitude) for a point we want to find
nearest stations to (e.g. c(80, 6)). If not provided the query will be based on a mean longitude and latitude among available dataset.}

\item{no_of_stations}{how many nearest stations will be returned from the given geographical coordinates; default 30}

\item{allow_failure}{logical - whether to allow or stop on failure. By default set to TRUE. For debugging purposes change to FALSE}
}
\value{
A data.frame with number of nearest station according to given point columns describing stations parameters
(e.g.  ID station, distance from point, geographic coordinates, etc.) where each row represent a measurement,
each station which has a measurements on selected date. If \code{add_map = TRUE} additional map of downloaded data is added.
}
\description{
Returns a data frame of meteorological stations with their coordinates and distance from a given location based on the noaa website.
The returned list is valid only for a given day.
}
\examples{
\donttest{
  nearest_stations_noaa(country = "SRI LANKA", 
  point = c(80, 6),
  add_map = TRUE, 
  no_of_stations = 10)
  
  uk_stations = nearest_stations_noaa(country = "UNITED KINGDOM", no_of_stations = 100)
}

}
