% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation.r
\name{mcEvaluateAll}
\alias{mcEvaluateAll}
\title{Evaluates all next page clicks in a clickstream training data set against a test data}
\usage{
mcEvaluateAll(
  mc,
  trainingCLS,
  testCLS,
  includeChiSquare = TRUE,
  returnChiSquareOnly = FALSE
)
}
\arguments{
\item{mc}{A markovchain object that corresponds to a list of clusters.}

\item{trainingCLS}{Clickstream object with training data (this should be the data used to build the markov chain object).}

\item{testCLS}{Clickstream object with test data.}

\item{includeChiSquare}{Should the result include the chi-square value?}

\item{returnChiSquareOnly}{Should the result only consist of the chi-square value?}
}
\description{
Evaluates all next page clicks in a clickstream training data set against a test data. Handles higher order by cycling through every possible pattern permutation. Produces a report of observed and expected values in a matrix.
}
\examples{
training <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p",
              "User2,i,c,i,c,c,c,d")

test <- c("User1,h,c,c,p,c,h,c,d,p,c,d,p",
             "User2,i,c,i,p,c,c,d")

csf <- tempfile()
writeLines(training, csf)
trainingCLS <- readClickstreams(csf, header = TRUE)
unlink(csf)

csf <- tempfile()
writeLines(test, csf)
testCLS <- readClickstreams(csf, header = TRUE)
unlink(csf)

mc <- fitMarkovChain(trainingCLS, order = 2)
mcEvaluateAll(mc, trainingCLS, testCLS)
}
\seealso{
\code{\link[=mcEvaluate]{mcEvaluate}}
}
\author{
Theo van Kraay \email{theo.vankraay@hotmail.com}
}
