% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_numeric.R
\name{convert_to_numeric}
\alias{convert_to_numeric}
\title{Convert columns into numeric}
\usage{
convert_to_numeric(data, target_columns = NULL, lang = c("en", "fr", "es"))
}
\arguments{
\item{data}{The input \code{<data.frame>} or \code{<linelist>}}

\item{target_columns}{A \code{<vector>} of the target column names. When the
input data is a \code{<linelist>} object, this parameter can be set to
\code{linelist_tags} to apply the conversion exclusively to the
tagged columns. .}

\item{lang}{A \code{<character>} with the text's language. Currently one of
\code{"en"}, \code{"fr"}, \code{"es"}.}
}
\value{
A \code{<data.frame>} or \code{<linelist>} wherein all the specified
or detected columns have been transformed into numeric format after the
conversion process.
}
\description{
When this function is invoked without specifying the column names to be
converted, the target columns are the ones returned by the \code{scan_data()}
function. Furthermore, it identifies columns where the proportion of numeric
values is at least twice the percentage of character values and performs the
conversion in them. The function internally makes call of the main function
from the \pkg{numberize} package.
}
\examples{
data <- readRDS(
  system.file("extdata", "messy_data.RDS", package = "cleanepi")
)

# convert the 'age' column into numeric
dat <- convert_to_numeric(
  data = data,
  target_columns = "age",
  lang = "en"
)

# print the report from this operation
print_report(data = dat, "converted_into_numeric")
}
