% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_put_custom_transfer}
\alias{scripts_put_custom_transfer}
\title{Transfer ownership of this object to another user}
\usage{
scripts_put_custom_transfer(
  id,
  user_id,
  include_dependencies,
  email_body = NULL,
  send_email = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the resource that is shared.}

\item{user_id}{integer required. ID of target user}

\item{include_dependencies}{boolean required. Whether or not to give manage permissions on all dependencies}

\item{email_body}{string optional. Custom body text for e-mail sent on transfer.}

\item{send_email}{boolean optional. Send email to the target user of the transfer?}
}
\value{
A list containing the following elements:
\item{dependencies}{array, An array containing the following fields: 
\itemize{
\item objectType string, Dependent object type
\item fcoType string, Human readable dependent object type
\item id integer, Dependent object ID
\item name string, Dependent object name, or nil if the requesting user cannot read this object
\item permissionLevel string, Permission level of target user (not user's groups) for dependent object. Null if no target user or not shareable (e.g. a database table).
\item description string, Additional information about the dependency, if relevant
\item shared boolean, Whether dependent object was successfully shared with target user
}}
}
\description{
Transfer ownership of this object to another user
}
